﻿
# Transformation bounce (sautillement)
transform bounce:
    yoffset 0
    linear 0.1 yoffset -10
    linear 0.1 yoffset 0


# Callback générique, lié à un tag par personnage
init python:
    def make_bounce_callback(tag):
        def bounce_talk(event, interact=True, **kwargs):
            if event == "begin" and renpy.showing(tag):
                renpy.show(tag, at_list=[bounce])
        return bounce_talk

define config.main_menu_music = "audio/1.mp3"

# Déclarez les personnages utilisés dans le jeu.
define p = Character('[PlayerName]', color="#c8ffc8", image = "player1")
define i = Character('Interne', color="#a2eaa2", image = "narrateur1")
define e = Character('Genoveva', color="#a8c9ff",  callback=make_bounce_callback("genoveva"))
define g = Character('Galeazzo', color="#c97474", callback=make_bounce_callback("galeazzo"))
define a = Character('anteo', color="#e0cfa6",  callback=make_bounce_callback("anteo"))
define m = Character('marius', color="#b199ff", callback=make_bounce_callback("marius"))
define s = Character('sante', color="#9bc4a8", callback=make_bounce_callback("sante"))
define r = Character("roger", color="#b7b7b7", callback=make_bounce_callback("roger"))
define u = Character("unity", color="#ffa87c", callback=make_bounce_callback("unity"))
define o = Character("aumonier", color="#dcb8ff", callback=make_bounce_callback("aumonier"))
define n = Character("gentile", color="#d6d89b", callback=make_bounce_callback("gentile"))
define z = Character("Savitri", color="#ffb5c4", callback=make_bounce_callback("Savitri"))
define b = Character("eleve", color="#b0c4c4", callback=make_bounce_callback("eleve"))



# Déclaration des sprites regroupés par TAG
image genoveva neutral = "images/char/Genoveva/SANS BG/ge4.png"
image genoveva neutral2 = "images/char/Genoveva/SANS BG/ge5.png"
image genoveva neutral3 = "images/char/Genoveva/SANS BG/ge6.png"
image genoveva neutral4 = "images/char/Genoveva/SANS BG/ge7.png"
image genoveva neutral5 = "images/char/Genoveva/SANS BG/ge8.png"
image genoveva neutral6 = "images/char/Genoveva/SANS BG/ge10.png"
image genoveva neutral7 = "images/char/Genoveva/SANS BG/ge9.png"
image genoveva angry = "images/char/Genoveva/SANS BG/ge2.png"
image genoveva smile = "images/char/Genoveva/SANS BG/ge3.png"
image genoveva lundimatin = "images/char/Genoveva/SANS BG/ge11.png"
image genoveva chokbarre = "images/char/Genoveva/SANS BG/ge12.png"
###################################################################
image side narrateur1 = "images/char/narrateur/SANS BG/na1.png"
image side player1 = "images/char/player/SANS BG/pla1.png"
###################################################################
image marius neutral = "images/char/marius/SANS BG/ma1.png"
image marius happy = "images/char/marius/SANS BG/ma4.png"
image marius surprised = "images/char/marius/SANS BG/ma5.png"
image marius smirk = "images/char/marius/SANS BG/ma6.png"
###################################################################
image anteo neutral = "images/char/anteo/SANS BG/an1.png"
image anteo annoyed = "images/char/anteo/SANS BG/an3.png"
##################################################################
image sante neutral = "images/char/sante/SANS BG/sa1.png"
##################################################################
image roger neutral = "images/char/roger/SANS BG/ro1.png"
image roger annoyed = "images/char/roger/SANS BG/ro2.png"
image roger suspicious = "images/char/roger/SANS BG/ro3.png"
##################################################################
image unity neutral = "images/char/unity/SANS BG/un1.png"
##################################################################
image galeazzo neutral = "images/char/Galeazzo/SANS BG/ga1.png"
image galeazzo angry = "images/char/Galeazzo/SANS BG/ga2.png"
#################################################################
image aumonier neutral = "images/char/aumonier/SANS BG/am1.png"
#################################################################
image gentile neutral = "images/char/gentile/SANS BG/gg1.png"


#variable utiliser
default scoredocile = 0
default scoremuet = 0
default scoredefiant = 0
default scoretimide = 0
default scoreaudacieux = 0
default scoreblame = 0
default promesse1 = 0

# Le jeu commence ici
label start:
    play music "audio/4.mp3"
    #Affichage logo CPL
    window hide 
    scene bg copyleft
    $ renpy.pause(3)
    scene black
    window hide 

    # Chapitre 1
    # Acte 1
    # Scène 1 (carton)
    scene bg carton
    $ renpy.pause(6)
    scene black
    "Avoir été peut-être utile"
    "C’est un rêve modeste et fou"
    "Il aurait mieux valu le taire"
    "Vous me mettrez avec en terre"
    scene bg deathbyexplod
    "Comme une étoile au fond d’un trou"
    window hide 


    scene bg dimanche
    pause 
    scene bg dimanche2
    pause 

    # Acte 4
    # Scène 1 (carton/interne)
    scene bg base
    "Centre de formation citoyenne."
    "Un bâtiment austère, gris, sans âme, dressé comme une cicatrice au milieu d’un paysage étouffé."
    "Dix-sept ans après le début de l’Opération spéciale de paix. Dix-sept ans de propagande, de serments forcés, de familles brisées."
    i "Ici, on ne formait pas seulement des citoyens. On moulait des instruments, interchangeables, obéissants, prêts à s’effacer pour la Nation."

    # Acte 5
    # Scène 1 (interne/Galeazzo/Player)
    scene bg bureau
    i "La voix qui m'invitait à entrer n'était ni sympathique ni compatissante. Elle tranchait, froide, presque métallique."
    i "Le directeur ne me regardait pas, trop occupé à lire un dossier qui semblait déjà sceller mon destin."
    i "Je m'approchai du bureau, mais il n'y avait aucune chaise de mon côté. Seul le directeur était assis, maître de son espace comme un juge sur son estrade."
    i "J'attendais debout... comme un con. Les secondes s’étiraient, chaque tic-tac de l’horloge résonnait comme un coup de marteau."
    i "Comment peut-il travailler avec ce vacarme ? Le bureau du directeur n'est pas seulement un lieu de travail : c'est une salle de jugement. Les murs nus, les rideaux tirés, la poussière soigneusement effacée... tout respirait la sévérité."
    i "En tout cas, c'est l'impression que donne le décor. Une cage dorée pour ceux qui détiennent le pouvoir."
    show galeazzo neutral
    g "\"Vous êtes désormais cadet de cette école. Mais ne vous méprenez pas… votre place ici n'est pas acquise.\""
    i "Super. Je n'ai même pas encore posé mes affaires que je suis déjà en période d'essai. Comme si mon souffle même devait mériter une approbation."
    g "\"En temps normal, nous n'acceptons pas d'étudiants en cours d'année. Mais, étant donné la situation, nous ferons une exception.\""
    g "\"Considérez votre présence ici comme une faveur. Des jeunes de votre âge sont envoyés chaque jour au front, pour défendre la paix que notre Nation offre au monde.\""
    i "Une faveur. Voilà ce que je suis : un poids toléré, un hasard dans les rouages."
    g "\"Bien. Quel est votre nom, cadet ?\""
    $ PlayerName = renpy.input("Comment vous appelez-vous ?", "", length=15, exclude=" 0123456789+=,.?!<>{}[]()").strip() or "Ravachol"

    menu:
        "\[DOCILE\] \"[PlayerName], monsieur le directeur\"":
            i "J'allais parler, mais je n'ai même pas eu le temps d'ouvrir la bouche que voilà qu'il répond lui-même à sa propre question, comme si mon existence ne comptait pas."
            jump prenom



        "\[DEFIANT\] \"C'est à moi que vous parlez ? Ou à votre dossier ?\"":
            i "J'allais parler, mais je n'ai même pas eu le temps de dire un mot que voilà qu'il répond à sa propre question. Peut-être qu’il préfère converser avec ses papiers plutôt qu’avec moi."
            jump prenom

label prenom:
    g "\"Cadet [PlayerName].\""
    i "Il leva enfin les yeux de son dossier, laissant apparaître un regard strict et froid. Ses pupilles semblaient sonder mon âme, ou peut-être simplement mesurer mon degré d’utilité."
    g "\"Vous, vous avez la chance d’être ici. De recevoir une éducation. De devenir un outil utile, plutôt qu’un sacrifice anonyme.\""
    i "\"Chance\", hein… Oui, c'est vrai, je suis ravi d’être façonné en outil plutôt que réduit en poussière au front. Champagne !"
    i "Ses mots tombaient comme des pierres, lourds, sans chaleur. Ici, l’humanité n’était qu’une variable secondaire."

    menu:
        "\[DOCILE\] \"J’ai conscience de ma chance, monsieur. Je ne la gâcherai pas.\"":
            jump Docile



        "\[DEFIANT\] \"Je ne sais pas si on peut vraiment parler de chance…\"":
            jump rebelle

label Docile :
    $ scoredocile += 1
    p "\"J’ai conscience de ma chance, monsieur. Je ne la gâcherai pas.\""
    i "Voilà. Il aime ça. Les phrases toutes faites. La bonne vieille soumission. Quelle abrutie."
    g "\"Nous verrons, mais je l'espère pour vous.\""
    i "Il me jauge comme un marchand qui inspecte une marchandise. Un sourire aurait été trop demander."
    jump docilesmuetsilence



label rebelle :
    $ scoredefiant += 1
    p "\"Je ne sais pas si on peut vraiment parler de chance…\""
    i "Tout à coup, son air strict se transforma en un regard de dédain, plein de hargne."
    g "\"Ce jeu-là ne vous mènera à rien. Pensez à votre mère et ne soyez pas ingrat.\""
    i "Ah, le fils de pute : il ose parler de ma mère. Il connaît ma situation et l'utilise contre moi. Une arme invisible, mais tranchante."
    i "Mon poing se crispe. Pourtant, je reste figé, prisonnier de ce bureau qui sent la cire et la poussière froide."

    menu:
        "\[BOUCHE BÉE] \"…\"":
            jump docilesmuetsilence

        "\[MUET] \"…\"":
            jump docilesmuetsilence

        "\[ABASOURDI] \"…\"":
            jump docilesmuetsilence

label docilesmuetsilence :

    i "Il replonge dans son dossier et se met à lire à voix haute, chaque syllabe pesant comme un verdict."
    g "\"Nom : [PlayerName]. Antécédents : … troublants. Vous n'entrez pas ici comme une page blanche.\""
    i "Ah, mon fameux dossier. Résumé officiel de “qui je suis”, version régime. J'espère qu'ils ont mis une photo où j'ai l'air présentable."
    i "La vérité ? Ce papier ne dit rien de moi. Mais à ses yeux, il est plus réel que ma propre chair."
    g "\"Avant de poursuivre, j’aimerais éclaircir un point de votre dossier.\""
    i "Le ton a changé. Plus lent, presque curieux. Comme un serpent qui goûte l’air avant de frapper."
    g "\"Vous venez de la colonie de Chorath, n’est-ce pas ?\""
    p "\"Oui, monsieur.\""
    g "\"Votre père y occupait un poste... important.\""
    i "Le mot traîne, chargé d’un parfum de soupçon. Il attend ma réaction, mais je ne lui donne rien."
    g "\"Et il... s’est donné la mort. C’est exact ?\""
    i "Un silence. Long. Suffisant pour faire trembler l’air."
    p "\"C’est ce que dit le rapport.\""
    g "\"Ce que dit le rapport ?\""
    i "Je hausse imperceptiblement les épaules. Il veut me forcer à parler, mais les mots ont des barbelés."
    p "\"Je n’étais pas là. On m’a simplement appris que c’était... inévitable.\""
    g "\"Inévitable. Intéressant choix de mot.\""
    i "Je sens son regard peser sur moi, cherchant ce que je ne dirai pas."
    g "\"Les raisons de son acte sont... floues. Vous savez, ici, nous valorisons la clarté.\""
    i "La clarté ? Il veut que je dise ce que tout le monde chuchote ?"
    p "\"Mon père... n’était pas en accord avec certaines règles. Il a préféré se taire définitivement plutôt que d’être réduit au silence.\""
    i "Voilà. C’est dit. Pas tout, juste assez pour qu’il comprenne."
    g "\"Je vois. Vous portez donc un héritage... complexe. J’espère que vous saurez le redresser.\""
    i "Redresser, comme on redresse une tige tordue. Ou un cadet rebelle."
    g "\"Nous ne jugeons pas les fautes des pères ici. Seulement celles des fils.\""
    i "Mensonge. Ici, tout héritage est une condamnation déguisée."
    i "Il referme le dossier d’un geste sec. La conversation est close, mais le poids reste, collé à ma peau comme une ombre humide."
    g "\"Ici, vous apprendrez trois choses : la discipline, l'obéissance, le sacrifice. Sans elles, vous ne serez rien.\""
    i "Trois mots magiques. On croirait presque un slogan publicitaire. Sauf qu'ici, le produit, c'est moi."
    i "Discipline, obéissance, sacrifice... Des chaînes polies qu’on enfile avec le sourire."

    menu:
        "\[DOCILE] \"Je comprends. Je suivrai ces règles.\"":
            jump docile2



        "\[DEFIANT] \"Trois mots… mais aucun ne parle de penser par soi-même.\"":
            jump defiant2

label docile2 :
    $ scoredocile += 1
    p "\"Je comprends. Je suivrai ces règles.\""
    i "Et je vais aussi manger mes légumes et me coucher tôt, promis."
    g "\"Vous semblez savoir ce qu’on attend de vous. Tant mieux.\""
    jump docilemuetdefiant2



label defiant2 :
    $ scoredefiant += 1
    g "\"Penser est un privilège réservé aux supérieurs. Pas à vous.\""
    i "Super, donc je peux ranger mon cerveau au placard. Bonne ambiance."
    i "Et voilà, l’homme vient de dire tout haut ce que le régime pense tout bas."
    jump docilemuetdefiant2

label docilemuetdefiant2 :
    g "\"Vous êtes ici par tolérance, pas par mérite. Votre présence est un test. Si vous échouez… le Conseil me donnera raison de vous avoir refusé.\""
    i "Son ton est tranchant, implacable. Chaque mot vise à rappeler que je ne suis qu’un invité de trop."

    menu:
        "\[DOCILE] \"Je vous prouverai que vous n’avez pas fait erreur.\"":
            jump docile3



        "\[DEFIANT] \"Le Conseil avait raison. Vous verrez.\"":
            jump defiant3
label docile3 :
    $ scoredocile += 1
    p "\"Je vous prouverai que vous n’avez pas fait erreur.\""
    i "Si ça peut le calmer, je suis prêt à jouer l'élève modèle."
    g "\"Voilà une parole sensée. À vous maintenant de la mettre en pratique.\""
    jump docilemuetdefiant3



label defiant3 :
    $ scoredefiant += 1
    p "\"Le Conseil avait raison. Vous verrez.\""
    i "Bravo, moi ; voilà comment se faire haïr en trois secondes chrono."
    g "\"L’insolence est une faiblesse. Ici, elle ne vous sauvera pas.\""
    jump docilemuetdefiant3

label docilemuetdefiant3 :
    i "Un silence lourd suit. Le directeur range mon dossier dans le tiroir de son bureau, se lève, contourne le meuble et s'approche, ses pas claquant sur le sol ciré."
    g "\"Vous pensez être spécial. Mais ici, vous serez brisé… ou forgé. Il n'y a pas d'alternative.\""

    if scoredefiant >= 3:
        jump defiant4

    elif scoredocile >= 3:
        jump docile4

    elif scoremuet >= 3:
        jump muet4
    else:
        jump docilemuetdefiant4

label defiant4 :
    g "\"Vous n'êtes plus dans les colonies ; ici, vous êtes dans la sainte patrie.\""
    g "\"Ici, il y a des règles à respecter et des conséquences pour ceux qui ne les suivent pas.\""
    g "\"Votre comportement est inacceptable. Je vous sanctionne d'un blâme.\""
    g "\"Trois blâmes et vous serez exclu.\""
    g "\"La plupart traversent leur scolarité sans prendre un seul blâme.\""
    g "\"Vous venez à peine d'arriver et vous en avez déjà un.\""
    g "\"Vous ne resterez pas très longtemps parmi nous.\""
    i "Chouette, je peux encore encaisser deux blâmes, je suis large ! Pas de quoi s'inquiéter."
    i "Il n'a pas l'air de m'apprécier, tant mieux : il y a des personnes qu'il vaut mieux haïr à distance."
    $ scoreblame += 1
    jump docilemuetdefiant4

label docile4 :
    g "\"J'ai un bon pressentiment : vous saurez vous effacer au profit du groupe.\""
    g "\"Sinon, je serai là pour vous remettre dans le droit chemin.\""
    g "\"Sachez que la porte de mon bureau est toujours ouverte au cadet en cas d'urgence.\""
    i "Oui, si j'ai besoin d'un psychopathe en urgence, je saurai où vous trouver."
    p "\"Merci, monsieur le directeur.\""
    jump docilemuetdefiant4



label docilemuetdefiant4 :
    g "\"Attendez ici, je reviens.\""
    hide galeazzo 
    i "Mais où va-t-il ? Il me laisse seul ?"
    i "Bon, j'imagine que ça veut dire qu'il n'y aura pas de fête de bienvenue..."
    i "J'aime autant que ce tête-à-tête se termine."

    #ACTE 5
    #Scène 2 (interne)
label a1s2 :
    i "Je suis seul dans le bureau. Ce serait dommage de ne pas en profiter..."
    i "L’air sent la poussière et le cuir. Chaque meuble est une pièce de théâtre, soigneusement disposée."

    menu:
        "\[REGARDER BIBLIOTHÈQUE] Fouiller la bibliothèque":
            jump bibliotheque

        "\[POUBELLE] Fouiller la poubelle":
            jump poubelle

        "\[BUREAU] Fouiller le bureau":
            jump bureau

label bibliotheque :
    i "Je m'approche de la bibliothèque et jette un œil rapide aux étagères."
    i "Des manuels de propagande, des livres d’histoire réécrite, des dictionnaires qui sentent la poussière. Pas une trace de roman, pas un seul poème."
    i "Ici, la fiction est proscrite. Seule la vérité officielle a droit de cité."
    jump a4s2

label poubelle :
    i "Je fouille rapidement la poubelle. Rien d'intéressant à première vue."
    i "Juste des papiers froissés, des notes griffonnées. Peut-être qu’en les recollant, on trouverait des fragments de vérité… ou seulement des listes de courses."
    jump a4s2    

label bureau :
    i "Je tente d’ouvrir le bureau… mais il est verrouillé. Impossible de l’ouvrir."
    jump a4s2
#####################3.40################## premier choix
    #ACTE 5
    #Scène 3 (interne/player/galazzo/genoveva)
label a4s2:
    scene bg bureau
    with fade
    i "La porte s’ouvrit dans un grincement maîtrisé, un bruit qui s’étira dans le silence comme une note grinçante."
    i "Le directeur était de retour. Son pas lourd résonnait sur le plancher ciré, et je me tendis instinctivement, comme si sa simple présence exigeait une posture raide."
    show galeazzo neutral at left
    i "Il passa le seuil en premier. Son visage affichait un étrange sourire idiot, décalé, presque absurde dans ce décor si rigide."
    i "Mais c’est en la voyant apparaître derrière lui que j’ai immédiatement compris pourquoi ce rictus lui collait aux lèvres."
    show genoveva neutral
    i "Elle. Une apparition dans ce bureau poussiéreux, une lumière qui se découpait sur l’ombre du couloir. Elle était belle à s'en crever les yeux. Belle au point de me couper le souffle."
    with dissolve
    g "\"Cadet [PlayerName], voici Genoveva. Elle est ici depuis deux ans. Elle vous fera visiter le complexe et veillera à vous montrer votre dortoir.\""
    i "Genoveva… Le nom résonna dans ma tête, presque trop doux pour ce lieu froid."
    i "Sa silhouette était fine, son port assuré. Ses yeux, d’un bleu éclatant, semblaient vibrer d’une vie étrangère à ces murs ternes."
    i "Et ce sourire… constant, énigmatique, impossible à décrire. Elle respirait la gaieté, une énergie vive qui contrastait violemment avec l’atmosphère étouffante."
    i "Peut-être que le décor jouait pour elle. Le bureau strict, plus vieux que ma grand-mère (mais sans doute plus solide), l’odeur de cire rance, ce directeur raide comme un pieu…"
    i "Et moi, déjà épuisé, morose, prêt à voir du gris partout. Alors forcément, dans cette ambiance pourrie, son éclat me parut irréel."
    i "Oui, même si c’est cliché : on aurait dit un ange descendu dans une salle de torture."
    g "\"Je compte sur vous, Genoveva.\""
    e "\"Oui, monsieur le directeur.\""
    g "\"Cadet [PlayerName], n’oubliez pas ! Discipline ! Obéissance ! Sacrifice !\""
    i "Pfff… toujours les mêmes mots, comme un disque rayé. Qu’est-ce que tu veux que je réponde à ça…"
    i "Je le fixe droit dans les yeux, avec ce regard qui dit 'j’ai compris, inutile d’en rajouter'."
    i "Il me jauge, l’air désabusé… Bon... Tant pis ou tant mieux. Avec un peu de chance, je ne le reverrai pas avant longtemps."
    i "Et si j’ai énormément de chance, il fera un AVC ce soir, seul sur ses chiottes, et je ne le recroiserai qu’à ses obsèques."
    i "Je me retourne aussitôt vers Genoveva, presque soulagé que ce soit elle mon prochain guide dans ce labyrinthe."
    i "Elle me sourit, un sourire trop franc pour que je le soutienne. Mes yeux glissent malgré moi vers le parquet, comme si fixer le bois poli m’évitait de me brûler à sa lumière."
    i "Je me dirige vers la porte, le cœur un peu trop lourd pour quelqu’un qui sort simplement d’un bureau."
    e "\"Bonne soirée, monsieur le directeur. À tout à l'heure.\""
    i "Sa voix… douce, légère, presque musicale. Elle souriait en parlant, ça s’entendait. Même dans ces mots banals, elle avait mis de la chaleur."
    i "Oui, définitivement, elle contrastait avec tout le reste. Elle était comme une fissure dans le béton, une ouverture vers un monde qui n’était pas fait de règles et de cendres."
    #with fade
#######################5.40#########################
    #ACTE 6
    #Scène 1 (interne/player/genoveva)
scene bg couloir
with fade
show genoveva neutral
i "Enfin dehors. L’air du couloir ne sentait pas meilleur, mais je respirais comme si je venais d’échapper à une cellule."
i "Je cherche désespérément quelque chose de drôle, d’intelligent à dire. Un mot qui briserait la glace, qui montrerait que je ne suis pas qu’un pion de plus."
i "Mais les mots se bloquent. Heureusement pour moi, elle prend les devants. Plus vive, plus libre que moi. Moins troublée, sans doute, par ma présence maladroite."
e "\"Alors… bienvenue au Centre. Je suppose qu’il n’a pas été très… chaleureux avec toi ?\""
i "Sa voix est douce, mais teintée d’ironie. Enfin. Enfin quelqu’un qui parle comme un être humain dans ce lieu qui ressemble à une machine."
e "\"Fais attention à lui, il a la sanction facile.\""
if scoreblame >= 1:
    jump blame1

elif scoreblame <= 0:
    jump blame0

label blame0:
    p "\"merci du conseil, je tâcherai de m’en souvenir\""
    jump visite_start

label blame1:
    p "\"Oui, j’ai remarqué, j’ai eu droit à un blâme, de ce que j'ai compris il y en a 3 a collectioner\""
    show genoveva chokbarre 
    e "\"Tu as déjà eu un blâme ?!\""
    i "Elle a l’air choquée. Son regard a changé, et son sourire a disparu, elle reste interdite "
    p "\"t'inquiète il me reste deux blame avant le renvoi, je suis large\""
    e "..."
    i "Merde me voilà à regretter d’avoir peut-être été un peu trop franc."
    jump visite_start

label visite_start:
    show genoveva neutral2
    i "Nous marchons à travers les longs couloirs. Le béton froid semble avaler nos pas, chaque écho mourant aussitôt qu’il naît."
    i "Le plafond est bas, les néons crépitent, parfois un grésillement strident déchire le silence. La lumière est trop blanche, presque maladive, et donne à la peau une teinte spectrale."
    i "Tout est pensé pour discipliner. Les murs lisses, les lignes droites, le rythme des pas. Ici, même l’air paraît rationné."
    e "\"Je vais te montrer les endroits importants. Tu finiras par t’y faire.\""
    i "Ses mots s’entrechoquent dans ma tête. 'M’y faire' ? Si un jour je m’y fais, c’est que j’aurai perdu une bataille invisible contre ce lieu."

    #ACTE 7
    #Scène 1 (interne/player/genoveva)
    scene bg cantine
    with fade
    show genoveva neutral2
    e "\"Ici, c’est le réfectoire. Trois repas par jour, strictement à l’heure. Ne sois jamais en retard, les surveillants n’aiment pas ça.\""
    i "La salle s’ouvre devant moi comme une cathédrale de métal et de silence."
    i "De longues tables en rangs parfaits, toutes identiques, polies à l’excès. On dirait des lignes de soldats, prêtes à avaler et digérer en cadence."
    i "Il n’y a aucune odeur de nourriture, seulement un relent de désinfectant et de fer, comme si on effaçait jusqu’à l’idée du goût."
    i "Manger ici, ce n’est pas un plaisir. C’est un rituel. Une mécanique qui broie le temps, trois fois par jour, sans saveur ni chaleur."

    menu:
        "\[TIMIDE] \"Ça a l’air... très bien organisé.\"":
            $ scoretimide += 1
            p "\"Ça a l’air... très bien organisé.\""
            e "\"Organisé au point de t’enlever l’appétit. Si tu arrives trop tard, tu n’auras pas de choix. Et si tu arrives trop tôt, tu passes pour un affamé.\""
            i "Sa remarque glisse sur moi comme une confidence. Je comprends qu’elle en a bavé ici, qu’elle sait ce que c’est d’être un numéro dans cette file."
            jump visite_classes

        "\[AUDACIEUX] \"On dirait une prison.\"":
            $ scoreaudacieux += 1
            p "\"On dirait une prison.\""
            e "\"Et encore… tu n’as pas vu les dortoirs.\""
            i "Sur l’instant, elle donnait l’impression d’avoir parlé sans réfléchir, comme si ça lui avait échappé. Mais non : elle était trop maligne pour ça."
            i "Elle se rapproche légèrement, pose sa main sur mon épaule. Son geste est léger, mais son regard me transperce."
            e "\"Ne parle pas trop fort. Les murs retiennent les mots, et parfois ils les répètent aux mauvaises oreilles.\""
            i "Un frisson me traverse. Ce lieu n’enferme pas seulement les corps, il enferme aussi les phrases, les murmures, jusqu’aux pensées."
            jump visite_classes
    #ACTE 8
    #Scène 1 (interne/player/genoveva)
label visite_classes:

    scene bg classe
    with fade
    show genoveva neutral2
    e "\"Voici les salles de cours. Chaque journée est réglée à la minute : histoire officielle, exercices de logique, maniement des slogans… et un peu de sciences.\""
    i "Les salles sont impeccables, glacées dans leur symétrie. Les pupitres brillent d’un vernis si lisse qu’on pourrait s’y mirer, mais il n’y a aucun reflet vivant à capter."
    i "Pas une rature, pas une gravure, pas un mot laissé par un élève. Comme si chaque pensée, chaque trace personnelle avait été effacée aussitôt surgie."
    i "Même les murs sont nus, sans affiches, sans dessins. Juste la froideur d’un cadre où rien ne doit distraire de l’endoctrinement."
    i "Tout ici crie une seule idée : tu n’es pas un individu. Tu es une case, une ligne, un rouage."

    menu:
        "\[TIMIDE] \"Ça a l’air… instructif.\"":
            $ scoretimide += 1
            p "\"Ça a l’air… instructif.\""
            e "\"C’est un mot qu’ils adoreraient entendre...\""
            i "Elle sourit, mais dans ses yeux, je vois briller une fatigue que je reconnais. Une lassitude d’avoir entendu mille fois les mêmes phrases vides."
            jump visite_dortoirs

        "\[AUDACIEUX] Rester silencieux":
            $ scoreaudacieux += 1
            i "Je garde le silence. Parfois, se taire vaut plus que n’importe quelle réplique."
            i "Genoveva m’adresse un léger sourire, comme si elle avait deviné le poids de mes pensées. Comme si mon mutisme parlait pour moi."
            jump visite_dortoirs

    #ACTE 9
    #Scène 1 (interne/player/genoveva)
label visite_dortoirs:

    scene bg dortoir
    with fade
    show genoveva neutral
    e "\"Et voilà les dortoirs. Tu es affecté au numéro 4.\""
    i "Je franchis le seuil et la vision me serre la poitrine."
    i "Quatre lits. Quatre lits identiques, tirés au cordeau, leurs draps immaculés mais sans chaleur. Pas de photos, pas de livres, pas d’objets. Pas un souffle de vie."
    i "L’air est saturé de poussière et de désinfectant, une odeur aigre qui colle à la gorge. On dirait une morgue habillée de draps blancs."
    i "Un musée de l’ordre, où chaque respiration doit être alignée avec la suivante."

    menu:
        "\[TIMIDE] Hocher la tête avec un léger sourire":
            $ scoretimide += 1
            i "Je hoche doucement la tête. Je ne trouve pas de mots, alors je lui offre ce signe discret."
            i "Son sourire en retour est sincère, presque tendre. Pendant une seconde, le dortoir semble moins glacé."
            jump attraction

        "\[AUDACIEUX] \"Un vrai musée de l’ordre…\"":
            $ scoreaudacieux += 1
            p "\"Un vrai musée de l’ordre…\""
            e "\"Oui. Et nous sommes les pièces d’exposition.\""
            i "Sa voix claque dans l’air comme un constat amer. Elle aussi se sait prisonnière de cette vitrine."
            jump attraction

label attraction:

    p "\"J’imagine que ce n’est pas une chambre individuelle.\""
    e "\"C’est les quatre lits qui te font dire ça ?\""
    p "\"J’avoue que ça a joué.\""
    e "\"Tu partages ta chambre avec Sante, Marius et Anteo.\""

    #ACTE 10
    #Scène 1 (interne/player/genoveva)
    scene bg couloir
    with fade
    show genoveva neutral2
    i "Depuis le début de cette visite, nous n’avions croisé personne, comme si nous étions seuls dans cet établissement."
    i "J’essayais obstinément de trouver quelque chose de drôle à dire à propos du fait d’être seuls tous les deux."
    i "Mais tout ce qui me venait m’aurait, au mieux, valu une gifle."
    e "\"La visite touche à sa fin. Il ne reste plus qu’à voir la salle d’étude. C’est là que sont les autres jusqu’à 19h30.\""
    i "La visite touche à sa fin. Pourtant, j’aimerais que ce couloir s’étire à l’infini, juste pour rester à ses côtés un peu plus longtemps."
    i "Sa présence réchauffe l’air froid, ses mots allègent un peu le poids du silence qui règne partout ailleurs."
    i "Ses yeux croisent les miens. Juste un instant, mais dans ce bref échange, il y a plus que dans toutes les paroles du directeur."
    i "Un tremblement léger, quelque chose qui s’éveille, fragile mais obstiné."
    i "Nous prenons un autre couloir et passons devant d’autres dortoirs."
    e "\"Ce sont les dortoirs filles.\""
    p "\"Je peux voir ta chambre ?\""
    i "Elle a l’air mi-étonnée, mi-amusée."
    e "\"Oui, la voici.\""
    scene bg dortoir
    show genoveva neutral2
    p "\"C’est... très différent de la mienne.\""
    e "\"Tu aurais voulu qu’ils peignent les murs en rose ?\""
    p "\"Non, quand même pas… mais au moins quelques stickers de licorne et deux-trois paillettes...\""
    i "Elle me donne un coup d’épaule. Je me demande si elle est tactile comme ça avec tout le monde..."
    
    #ACTE 10
    #Scène 1 (nterne/player/genoveva)
    scene bg couloir
    show genoveva neutral2
    e "\"Voilà. Tu connais l’essentiel. Demain, tu commenceras les cours.\""

    menu:
        "\[TIMIDE] \"Merci… pour la visite... ça compte beaucoup pour moi.\"":
            $ scoretimide += 1
            p "\"Merci… ça compte beaucoup pour moi.\""
            e "\"Je… de rien, [PlayerName].\""
            i "Ses mots glissent sur moi comme une caresse. Je les retiens jalousement, comme si demain pouvait me les voler."
            jump chapitre2fin

        "\[AUDACIEUX] \"Et si on se retrouvait après le couvre-feu ?\"":
            $ scoreaudacieux += 1
            $ promesse1 +=1
            p "\"Et si on se retrouvait après le couvre-feu ?\""
            e "\"…Tu es courageux. Ou imprudent. On verra bien.\""
            e "\"Plus sérieusement : n’espère pas sortir après la rentrée dans les dortoirs. Ça te vaudrait une exclusion immédiate.\""
            i "Son sourire s’élargit, un éclat de défi dans ses yeux. ça me donne l’impression de respirer pour la première fois depuis mon arrivée."
            p "\"Tu en fais trop... tu verras quand je viendrai te voir tout à l’heure.\""
            e "\"Sérieusement : il y a des détecteurs de présence reliés à une alarme à l’entrée de notre couloir et dans la sortie du vôtre. Donc impossible de sortir et de se balader.\""
            p "\"Comme ça, quand tu entendras l’alarme, tu sauras que j’arrive.\""
            jump chapitre2fin

label chapitre2fin:

    i "Elle nous arrête devant une porte."
    e "\"C’est la salle d’étude. Ici, normalement, on révise. Mais de toute manière, ça se termine dans dix minutes et après c’est le repas.\""
    i "C’est le moment où l’on se sépare, j’imagine. Dommage, c’était sympa. J’aurais aimé que ça dure."
    i "J’essaie désespérément de trouver un truc à dire avant cette séparation, mais comme toujours… rien ne vient."
    i "Elle frappe à la porte, puis entre. Je la suis."
    #####################################10.00################AUDACIEUX
    #ACTE 11
    #Scène 1 (interne/player/genoveva)
    scene bg etude
    show genoveva neutral
    i "La salle d’étude. Un long rectangle glacé, saturé d’un silence oppressant."
    i "Des dizaines de cadets sont assis en rangs, les têtes courbées sur des manuels identiques, comme des moines recopiant une même prière stérile."
    i "Le bruit des stylos est mécanique, presque militaire. Pas un rire, pas un mot échappé. Juste des yeux fatigués, des colonnes de lettres à ingurgiter."
    i "En guise de garde-chiourme, une surveillante dans la vingtaine me jette un regard appuyé, avant de m’indiquer ma place d’un signe de tête sec."
    i "Genoveva me désigne une table au fond, à côté d’un élève qui n’a pas levé les yeux une seule fois depuis notre entrée."
    e "\"Installe-toi ici. On doit rester jusqu’à dix-neuf heures trente. Après, on file directement au réfectoire.\""
    i "Je hoche vaguement la tête, tout en posant mes affaires sur le bois terne. L’air sent la craie, la poussière et une sueur contenue, comme si chaque respiration devait rester discrète."
    i "Genoveva s’assoit un peu plus loin… trop loin, à mon goût. Sa présence est là, mais inaccessible, diluée par la distance et par le silence imposé."
    hide genoveva
    i "Je jette un coup d’œil à l’horloge au mur : il reste dix minutes avant le repas. Dix minutes qui devraient s’écouler vite… mais ici, chaque seconde se traîne comme une bête blessée."
    i "Surtout que je n’ai rien à faire. Pas de manuel, pas de cahier, pas même un stylo. Je suis littéralement prisonnier de l’ennui."
    i "À ma gauche, mon voisin n’a toujours pas levé la tête. Ses doigts griffonnent avec une vitesse maladive, comme s’il voulait finir avant qu’on ne lui arrache sa feuille."
    i "Le papier se noircit sous sa main, raturé de formules et de slogans. Je détourne les yeux. Ce zèle me donne la nausée."
    i "Je ferme un instant les paupières, espérant me détacher de cette atmosphère étouffante. Juste quelques secondes d’évasion…"
    i "Quand soudain, un bruit de chaise brise la torpeur. Genoveva s’est levée, un dossier à la main. Elle traverse la salle d’un pas sûr, et miracle : elle vient droit vers moi."
    i "Les papiers serrés contre sa poitrine comme un trésor minuscule."
    show genoveva neutral3
    e "\"Tiens. Voici ton emploi du temps, un plan du centre, et une fiche de renseignements.\""
    i "Elle me tend les papiers avec un sourire discret, fragile comme une lumière interdite dans cet endroit sombre."
    e "\"Tu pourras me la rendre demain. Si tu veux, je l’apporterai moi-même au secrétariat pour t’éviter des ennuis.\""
    e "\"Tiens, je te donne aussi un stylo.\""
    i "Sa voix est basse, presque un murmure, mais elle a l’effet d’une bouffée d’air frais. Comme si, l’espace d’un instant, l’étude cessait d’être une prison."
    i "Je prends les documents, mes doigts frôlant les siens. Rien qu’un contact infime… mais assez pour allumer une chaleur inattendue dans ce décor glacé."
    i "Je la regarde repartir vers sa place."
    hide genoveva
    i "Le silence retombe. Mais cette fois, il n’a plus le même goût."
    i "Je regarde mon emploi du temps."
    i "Ça me permettra de savoir où et quand j’ai cours. Chaque case est remplie, aucun espace de respiration. Les jours se ressemblent déjà, quadrillés par des heures de discipline et de silence."
    i "Je repose la feuille, un goût amer dans la bouche. Voilà ma vie désormais : un calendrier de fer, une marche forcée."
    scene bg etude
    i "La cloche résonne enfin, métallique, brutale, arrachant tout le monde à sa torpeur."
    i "Les chaises raclent le sol en cadence. Les silhouettes se lèvent d’un même mouvement, comme une seule créature aux cent têtes."
    i "Pour ma part, pas grand-chose à ramasser : je fourre papier et stylo dans ma poche."
    i "En sortant, je vois Genoveva parler à deux garçons."
    i "Elle m’adresse un signe bref pour me signifier de venir."

    
    #ACTE 12
    #Scène 1 (interne/player/genoveva/marius/anteo)
label chapitre3:

    scene bg couloir
    with fade
    show genoveva neutral at left
    i "Genoveva discute avec deux garçons. Je comprends vite qu’il ne s’agit pas d’inconnus, mais de mes futurs camarades de dortoir."
    i "Ils ont l’air de la connaître, à en juger par leurs regards familiers. Et moi, je débarque, avec mes poches encore pleines de papiers et ma tête de nouveau venu."
    show anteo neutral at right
    show marius neutral at center
    e "\"Je vous présente [PlayerName], il partagera désormais votre chambre.\""
    e "\"[PlayerName], voici Marius et Anteo.\""
    m "\"Salut. Bienvenue en quarantaine de luxe.\""
    i "Genoveva lui pince le bras dans un geste amical."
    a "\"T’exagères. Ici, au moins, on a des draps propres.\""
    i "Marius a un ton blasé, presque moqueur. Anteo, lui, semble plus posé, plus terre-à-terre."
    i "Je ne sais pas encore si je dois rire ou me taire, mais l’idée d’une 'quarantaine de luxe' colle parfaitement à ce lieu."
    e "\"Bon, vous allez manger ensemble. Moi, je dois rejoindre le comité de réception. On se reverra demain.\""
    hide genoveva
    i "Elle s’éloigne, son pas rapide s’effaçant dans le couloir. Déjà, il manque quelque chose dans l’air."
    i "Marius m’adresse un clin d’œil ironique. Anteo, lui, m’invite d’un signe à marcher à leurs côtés."
    jump cantine_scene

    #ACTE 13
    #Scène 1 (interne/player/marius/anteo)
label cantine_scene:

    scene bg cantine
    with fade
    i "La cantine. Immense, glaciale, organisée comme une usine. Les cadets défilent en rang, plateau à la main, chacun avalant sa part sans un mot de trop."
    i "On nous sert une assiette standard : viande grise, légumes bouillis, et un pain dur comme une semelle. Pas de choix. Pas d’envie."
    show marius neutral
    show anteo neutral at right
    m "\"T’inquiète, c’est toujours comme ça. Le goût change jamais, par contre la consistance varie… parfois c’est caoutchouc, parfois plâtre.\""
    a "\"Ne l’écoute pas. Mange, sinon tu ne tiendras pas le rythme des cours.\""
    i "Je goûte une bouchée de viande, pâteuse et fade, comme mâcher un vieux torchon. Même l’eau a un arrière-goût métallique."
    i "Marius ricane, comme s’il savourait ma grimace plus que son propre repas."
    p "\"Vous mangez toujours à l’écart ?\""
    m "\"Ouais. Disons que c’est plus tranquille ici. Moins d’oreilles qui traînent.\""
    a "\"…Et moins de coudes à supporter. La plupart s’entassent au centre pour se faire voir.\""
    i "Leur complicité est claire : Anteo pose les mots sobres, Marius les tourne en dérision. Moi, je ne suis qu’un invité à leur table."
    p "\"Et… depuis quand vous êtes dans la même chambre ?\""
    m "\"Deux ans. Presque une vie entière, à l’échelle de ce trou.\""
    a "\"On a appris à… se supporter. C’est plus simple comme ça.\""
    i "Son ton est neutre, mais ses yeux fuient les miens l’espace d’un instant. Comme si cette 'simplicité' cachait quelque chose de plus lourd."
    p "\"Donc vous étiez trois depuis tout ce temps ?\""
    m "\"Trois, ouais.\""
    i "Un petit silence. Trop court pour être naturel."
    a "\"…Avant, il y avait un quatrième. Mais il a été transféré. Officiellement.\""
    m "\"Officiellement… ouais. Enfin, les 'transferts' ici, c’est comme les miracles : on y croit que si ça arrange.\""
    i "Marius pique son pain du bout de la fourchette et me lance un sourire qui n’a rien de chaleureux."
    p "\"Je vois… Et vous ne vous attendiez pas à un nouveau colocataire, hein ?\""
    m "\"Exact. Ça chamboule nos habitudes. Mais bon, on va s’adapter.\""
    a "\"Il faudra, oui.\""
    i "Je sens bien que ce 'il faudra' n’est pas dit pour me rassurer, mais plutôt comme une contrainte à laquelle ils se résignent."
    i "Autour, les conversations s’éteignent dès qu’un surveillant passe entre les tables. Roger, le surveillant des dortoirs garçons, nous observe un instant avant de s’éloigner."
    m "\"Tu verras, Roger fait mine d’être dur, mais c’est pas le pire. Tant que tu restes discret, il te fout la paix.\""
    a "\"…Discret. C’est le mot-clé ici.\""
    i "Je continue de manger mécaniquement, mais mon esprit tourne. Ce n’est pas qu’ils me rejettent ouvertement. C’est autre chose."
    i "Une gêne palpable, comme si ma présence était un grain de sable dans une mécanique bien huilée. Une mécanique qui n’a pas besoin d’un rouage de plus."
    i "Et, l’espace d’un instant, je me demande : est-ce qu’ils auraient préféré que je sois 'transféré' moi aussi, avant même d’avoir posé mes affaires ?"
    jump tempslibre

    #ACTE 13
    #Scène 1 (interne/player/marius/anteo)
label tempslibre:

    scene bg cour soir
    with fade
    i "Après le repas, une heure de 'temps libre'. Une expression trompeuse : seulement le droit de s’asseoir dans la cour ou de feuilleter des manuels."
    i "Les surveillants nous fixent distraitement, plus occupés à parler entre eux. Certains cadets discutent à voix basse, d’autres marchent en rond pour tromper l’ennui."
    i "Marius raconte une blague morbide à un autre groupe. Anteo, lui, reste silencieux, plongé dans un manuel défraîchi."
    i "En quittant la cantine, l’air me saisit immédiatement. Froid, chargé d’humidité, presque métallique. Après l’odeur de bouffe et de transpiration, c’est presque un soulagement."
    i "La cour s’étend devant nous, immense rectangle de béton cerné de grillages hauts comme des murs. Des lampadaires alignés projettent des halos jaunes qui tremblent légèrement dans la brise."
    i "Les autres cadets avancent en petits groupes. Personne ne traîne, personne ne rit fort. On sent dans leurs pas la fatigue."
    show marius neutral
    show anteo neutral at right
    m "\"Enfin… de l’air. On croirait pas, mais respirer dehors, c’est un luxe ici.\""
    i "Marius allume une cigarette roulée maladroitement. Une odeur âcre se mélange à l’air humide. Anteo détourne légèrement la tête, habitué à la manie de son camarade."
    p "\"Vous sortez toujours après le repas ?\""
    a "\"Dès qu’on peut. Marcher un peu avant de retourner au dortoir, ça aide à supporter la soirée.\""
    m "\"Sinon, tu restes enfermé direct, et la nuit paraît interminable. Mais à 21h, c’est obligation de rentrer.\""
    i "Le mot 'enfermé' résonne en moi. C’est dit à la légère, mais ça claque comme une vérité nue."
    i "On traverse lentement la cour. Le béton craque sous nos pas. Sur le grillage, le vent fait vibrer des morceaux de métal tordus, produisant une sorte de cliquetis régulier."
    m "\"Tu verras, après quelques semaines, tu connaîtras chaque fissure du sol, chaque grincement des portes. C’est comme si le lieu lui-même voulait s’imprimer dans ta tête.\""
    a "\"Certains trouvent ça rassurant. D’autres, étouffant.\""
    i "Je les écoute, partagé. Leur ton est naturel, presque amical, mais tout ce qu’ils disent me donne l’impression d’une prison déguisée en école."
    p "\"Vous deux, vous êtes ensemble depuis le début, non ?\""
    m "\"Ouais. Même chambre depuis deux ans. On se complète, en quelque sorte.\""
    a "\"Disons qu’on a trouvé un équilibre. Ici, c’est vital.\""
    i "Un équilibre… qui ne semble pas prévoir de place pour un troisième. Leurs regards se croisent brièvement, comme s’ils confirmaient une idée silencieuse."
    i "Nous passons près du bâtiment C. Une fenêtre claque, mal fermée. Une lumière clignote, vacillante, comme une veilleuse à l’agonie."
    m "\"Regarde ça. Trois semaines qu’elle clignote. Personne ne bouge. Tant que ça gêne pas la discipline, ils laissent tout pourrir.\""
    a "\"Ne fais pas attention. Marius aime collectionner ce genre de détails.\""
    m "\"Tu devrais aussi. Ce sont les détails qui disent tout sur l’endroit.\""
    i "Le silence revient. On entend juste les cris d’un surveillant au loin, ordonnant à un groupe de cadets de se dépêcher."
    i "Mon regard se pose sur les hautes grilles, couronnées de barbelés. Derrière, le ciel du soir est d’un bleu sombre, sans étoile. Comme si même la nuit refusait de percer ce lieu."
    p "\"C’est toujours… aussi calme, le soir ?\""
    m "\"Calme, ouais. Mais pas tranquille.\""
    a "\"Tu t’y feras. Tout est question d’habitude.\""
    i "Encore ce mot. Habitude. Comme si l’endroit cherchait à nous broyer dans une routine où plus rien ne surprend."
    i "Un coup de sifflet déchire soudain le silence. Tous les groupes accélèrent aussitôt, presque par réflexe. Anteo se redresse, attentif."
    a "\"Ça vient de l’entrée du bloc B. Il est temps de rentrer.\""
    m "\"Allez, le nouveau. Pas la peine de tester leur patience dès le premier soir.\""
    i "Je leur emboîte le pas. Marius avance d’un pas nonchalant, Anteo marche droit, presque militaire. Moi, je reste légèrement en retrait."
    i "Leurs deux ombres s’étirent côte à côte sur le mur. La mienne flotte derrière, en décalage, comme si elle n’avait pas encore trouvé sa place."

    #ACTE 14
    #Scène 1 (interne/player/marius/anteo/sante)
label dortoir_scene:

    scene bg dortoir
    with fade
    show marius neutral at left
    show anteo neutral at right
    show sante neutral at center
    i "Le dortoir numéro 4. Quatre lits, quatre cadets. Ce soir, nous sommes enfin réunis au complet : Sante est là, étendu sur son lit, l’air distant."
    i "Je dépose mes affaires sur le lit resté vide. Le silence est lourd, presque pesant. Marius finit par le briser, un sourire accroché au visage."
    show marius happy
    m "\"Bon, [PlayerName], t’as eu de la chance : t’es tombé dans la meilleure des chambres.\""
    m "\"Moi, je m’occupe de l’humour.\""
    show anteo neutral
    m "\"Anteo, c’est le sérieux.\""
    show sante neutral
    m "\"Et Sante… eh bien, Sante, il parle pas beaucoup.\""
    show anteo annoyed
    a "\"…\""
    show sante neutral
    s "\"Je parle quand c’est utile.\""
    i "Sa voix est grave, posée. Il n’a pas levé les yeux de son carnet, concentré sur ce qu’il écrit."
    i "Un type mystérieux, sans doute plus observateur que bavard."
    p "\"Alors… je suppose que je dois trouver ma place dans l’équation ?\""
    i "Un silence plane. Pas forcément hostile, mais chacun m’évalue à sa manière."
    show marius neutral
    i "Marius s’affale sur son lit en riant doucement."
    show anteo neutral
    i "Anteo croise les bras, le regard fixé sur moi comme pour jauger mes mots."
    i "Sante, lui, continue d’écrire, mais je devine qu’il écoute chaque syllabe."
    show marius happy
    m "\"T’inquiète, ça viendra vite. Ici, faut juste apprendre à encaisser… et à survivre aux blagues nulles que je vais te balancer.\""
    show anteo annoyed
    a "Ou à les ignorer."
    show marius surprised
    m "\"Oh, ça va, monsieur sérieux !\""
    show sante neutral
    s "\"…\""
    i "Un éclat de rire m’échappe. L’ambiance se détend un peu, malgré le poids du silence qui retombe aussitôt."

    #ACTE 14
    #Scène 2 (interne/player/marius/anteo/sante/roger)
label roger_presentation:

    scene bg dortoir
    with fade
    show marius neutral at left
    show anteo neutral at right
    show sante neutral at center
    i "Alors que nous échangeons encore quelques mots, la porte du dortoir s’ouvre brusquement."
    i "Une silhouette massive emplit l’encadrement. Le silence tombe aussitôt."
    hide sante
    show roger neutral at center with dissolve
    r "\"Bonsoir, cadets.\""
    r "\"Alors, votre week-end… c’était comment ?\""
    i "Les trois autres acquiescent vaguement, comme s’ils connaissaient déjà la routine. Son regard finit par se fixer sur moi."
    r "\"Je suis Roger. Surveillant de nuit pour le secteur des garçons.\""
    r "\"Mon rôle est simple : maintenir l’ordre, vérifier vos présences, et éviter que vous ne fassiez des bêtises. Mais si vous en cherchez… j’ai aucune patience.\""
    i "Sa voix est grave, mais irrégulière, comme s’il récitait un texte appris par cœur. Sa maladresse est palpable, et il semble plus nerveux que nous."
    show marius smirk
    m "\"Charmant…\""
    show anteo annoyed
    a "\"Tais-toi, Marius.\""
    hide roger
    show sante neutral
    s "\"Il nous a dit exactement la même chose la première fois qu’on l’a vu.\""
    hide sante
    show roger neutral
    r "\"Hé ho, les gars…\""
    i "Il avait soufflé ça, presque gêné. Clairement, Roger n’était pas du genre autoritaire. Le bon gars, mais au mauvais poste."
    r "\"En plus… je crois que le directeur est encore là.\""
    i "Ses mots avaient la fragilité d’un secret mal gardé. L’idée semblait le stresser plus que nous."
    hide roger
    show sante neutral
    s "\"Non, il est parti. Je l’ai vu, j’étais avec lui pour préparer la visite de l’amiral dans huit jours.\""
    hide sante
    show roger neutral
    i "Le pauvre Roger sembla tout à coup soulagé, comme s’il venait d’échapper à un piège invisible."
    r "\"Vous aurez bientôt l’occasion de tester vos limites. Mais pas la nuit. Après l’extinction des feux, personne ne circule. Compris ?\""
    p "\"Compris.\""
    r "\"Bien. Je vous souhaite une nuit tranquille. Et souvenez-vous… mes yeux ne dorment jamais vraiment.\""
    i "Il nous scrute un à un, comme pour graver nos visages dans sa mémoire. Puis, sans un mot de plus, il sort."
    i "Avant de refermer la porte, il ajoute d’une voix plus forte :"
    r "\"Extinction des feux dans dix minutes !\""
    hide roger
    i "Intrigué par ce que Sante a dit, je me tourne vers lui."
    p "\"Je ne t’ai pas vu à la cantine… Tu étais où ?\""
    show sante neutral
    s "\"Avec le directeur. On préparait l’arrivée de l’amiral. J’ai mangé après.\""
    i "Il disait ça d’un ton anodin, comme si ça n’avait aucune importance. Mais l’amiral… c’est littéralement le chef du gouvernement."
    p "\"Et ça consiste en quoi exactement ?\""
    s "\"Préparer les discours. Vérifier que le protocole sera respecté.\""
    i "Marius et Anteo restent étrangement silencieux, comme si mes questions touchaient un sujet qui les dérangeait."
    p "\"Genoveva fait partie de ça aussi, non ?\""
    i "J’avais essayé de poser la question d’un ton détaché, mais la réponse m’importait vraiment."
    s "\"Oui. Elle, le directeur, et son assistante.\""
    i "Le silence retombe, plus lourd que jamais. Même les murs semblent écouter."
    jump dortoir_confession



    #################
label dortoir_confession :

    scene bg dortoir
    with fade
    show marius neutral at left
    show anteo neutral at right
    show sante neutral at center

    i "Le silence retomba après le départ de Roger. Seul le bourdonnement lointain des néons remplissait la pièce."
    i "Marius s’allongea sur son lit, les bras croisés derrière la tête. Anteo rangeait méticuleusement ses affaires. Sante écrivait encore dans son carnet, impassible."
    i "Je me sentais étranger à ce calme. Comme si tout ici tournait à une vitesse différente de la mienne."

    m "\"Alors, le nouveau… T’as fait quoi pour qu’on t’envoie ici ?\""
    i "Le ton était léger, mais la question ne l’était pas. Anteo leva les yeux, curieux. Sante, lui, cessa d’écrire sans relever la tête."
    p "\"J’ai pas vraiment choisi d’être ici.\""
    m "\"Ah, ça, personne choisit. Mais y’a toujours une histoire derrière. Une bagarre ? Un sabotage ? Un parent trop zélé ?\""
    p "\"Mon père… était officier dans la colonie de Chorath.\""
    a "\"Chorath? Celle du front est ?\""
    p "\"Oui. Une colonie modèle, paraît-il. Jusqu’à ce qu’on découvre qu’elle avait… un défaut.\""
    i "Je marque une pause. Mes mains se serrent sans que je m’en rende compte."
    p "\"Mon père a préféré… disparaître avant qu’on le fasse pour lui.\""
    i "Un silence tombe. Le genre de silence qui vous écrase."
    m "\"Disparaître ?\""
    p "\"Appelle ça comme tu veux.\""
    i "Le mot 'suicide' ne sort pas. Je n’ai pas la force. Ni l’envie de lui donner ce pouvoir."
    a "\"Et toi, on t’a ramené ici, c’est ça ?\""
    p "\"Ouais. 'Réaffecté'. Une belle façon de dire 'placé sous surveillance'.\""
    i "Marius détourne le regard, visiblement mal à l’aise pour une fois."
    m "\"Putain… C’est pas banal comme histoire.\""
    s "\"Les fautes des pères retombent toujours sur les fils.\""
    i "La voix de Sante, calme et tranchante. Il ne me regarde pas, mais ses mots frappent juste."
    p "\"Je sais. On me le rappelle assez souvent.\""
    a "\"Tu n’étais pas obligé d’en parler.\""
    p "\"Si je ne le fais pas ici, je le ferai jamais. Autant que vous sachiez à qui vous partagez vos ronflements.\""
    m "\"Ah, si t’endors mal, t’inquiète, Anteo chante dans son sommeil. C’est apaisant comme un bombardement.\""
    a "\"Ferme-la, Marius.\""
    i "Un rire étouffé me monte à la gorge. Pas parce que c’est drôle, mais parce que c’est ça ou replonger dans le silence."
    i "Sante referme lentement son carnet, comme s’il venait de clore un chapitre invisible."
    s "\"Ton père a eu du courage, même si le monde ne lui en a pas laissé la chance.\""
    i "Je ne sais pas s’il cherche à me consoler ou simplement à dire la vérité. Mais ses mots me touchent plus que je ne veux l’admettre."
    p "\"Ouais… peut-être.\""
    s "\"Mon père à moi, c’était pas un officier. Juste un type avec une bouteille greffée à la main.\""
    i "Sa voix n’a pas changé de ton. Toujours égale, mais chaque mot est taillé au couteau."
    s "\"Il gueulait, frappait, cassait. Et moi, comme un con, je pensais que c’était l’alcool.\""
    m "\"Classique.\""
    s "\"Ouais. J’attendais le jour où il arrêterait. Je croyais que tout s’arrangerait. Qu’il redeviendrait quelqu’un.\""
    i "Un silence. Il lève enfin les yeux, fixant un point invisible sur le mur."
    s "\"Et puis un matin, il a arrêté. Plus une goutte. Il s’est levé sobre, clair, lucide.\""
    s "\"Et il était toujours aussi con.\""
    i "Personne ne rit. Même Marius reste figé, les lèvres entrouvertes."
    s "\"C’est là que j’ai compris : l’alcool, c’était pas la cause. C’était juste l’excuse.\""
    i "Ses doigts serrent son carnet jusqu’à en froisser la couverture."
    s "\"Certains hommes boivent pour oublier qu’ils sont des monstres. Le mien buvait pour se donner une raison de l’être.\""
    a "\"Tu l’as revu depuis ?\""
    s "\"Non. Et c’est très bien comme ça.\""
    i "Un silence lourd, mais pas vide. Un silence de compréhension. Le genre qui lie les gens sans qu’ils le veuillent."
    m "\"Putain… On devrait peut-être ouvrir un club des fils de connards.\""
    p "\"Ouais. Cotisation mensuelle : un soupir et un cauchemar.\""
    i "Un rire discret éclate, fragile, sincère. C’est rien, mais ça suffit à alléger l’air."
    i "Sante rouvre son carnet, griffonne quelque chose, puis murmure sans lever la tête :"
    s "\"Les pères font ce qu’ils veulent de leurs vies. Nous, on fait ce qu’on peut des ruines.\""
    i "Ses mots restent suspendus dans la pièce. Et pendant un instant, même le bourdonnement des néons se tait."
    i "Je m’allonge enfin, le regard perdu vers le plafond."
    i "Le dortoir est redevenu silencieux, mais pas froid. Pour la première fois, je sens que le poids de mon passé n’écrase pas tout. Pas ce soir."
    i "Peut-être qu’ici, entre ces trois-là, je trouverai un peu plus qu’une cellule."
    i "Peut-être, juste peut-être… une trêve."

    jump nuit

    ##################

    #ACTE 14
    #Scène 3 (interne/roger)
label nuit:

    i "Dix minutes plus tard, la porte s’ouvre à nouveau : Roger apparaît une dernière fois."
    hide sante
    show roger neutral
    r "\"Allez les gars, extinction des feux.\""
    i "La lumière s’éteint brutalement, coupant net nos échanges."
    i "Le silence s’impose, seulement troublé par les respirations des trois autres."

    #ACTE 14
    #Scène 4 (interne)

    i "Allongé sur mon lit, je fixe le plafond. Les secondes s’égrènent, interminables."
    i "Le souffle régulier de Marius emplit la chambre : il ronfle déjà. Anteo griffonne quelques notes dans son carnet, la mine crispée. Sante, lui, reste parfaitement immobile, les yeux ouverts dans l’obscurité."
    i "Quant à moi… une seule idée m’empêche de fermer l’œil, Genoveva."
    
    
    if promesse1 >= 1:
        jump okpromesse1

    elif promesse1 <= 0:
        jump pasdepromesse1

label pasdepromesse1:
    i "Je ferme finalement les yeux et finis par sombrer dans le sommeil."
    jump reve_colonies


    
    
label okpromesse1 :
    i "Je lui ai promis de la revoir ce soir. Et les promesses, ça se tient."
    i "Mais le couvre-feu est tombé. Chaque pas est une faute. Chaque geste, un risque."
    i "Je me redresse doucement, le cœur battant dans mes tempes, et me glisse hors du lit. Le parquet gémit sous mes pieds nus."
########################19.40#########
    #ACTE 15
    #Scène 1 (interne/player/roger)
    scene bg couloir
    with fade
    i "Le couloir est plongé dans une semi-obscurité. Les veilleuses d’urgence diffusent une lueur blafarde qui déforme les murs en ombres inquiétantes."
    i "Je n’ai pas fait dix pas qu’une silhouette massive se dresse devant moi. Immobile. Comme sortie des ténèbres."
    show roger neutral at center
    with dissolve
    i "Roger."
    r "\"Tu comptes aller où, cadet ? Après l’extinction des feux ?\""
    i "Sa voix résonne sourdement dans le couloir, plus grave encore dans le silence."
    p "\"Je vous cherchais… J’ai commencé aujourd’hui, et j’ai oublié de remettre une fiche d’information à Genoveva. Elle en avait besoin pour demain.\""
    show roger suspicious
    r "\"Tu la lui donneras demain matin. Là, j’ai enclenché l’alarme.\""
    p "\"Demain, elle commence plus tôt. Préparatifs pour la visite de l’amiral. Je voulais la lui donner ce soir, mais elle était déjà retenue ailleurs…\""
    i "Roger fronce les sourcils. Son regard me traverse, hésitant. On dirait qu’il cherche à deviner si je mens, ou s’il veut seulement s’en convaincre lui-même."
    r "\"…\""
    i "Son silence s’éternise. Puis il souffle par le nez, comme résigné, et fait un signe brusque de la main."
    r "\"Marche.\""
    i "Ses pas lourds résonnent contre les dalles. Je le suis, minuscule à ses côtés. Une procession muette dans les entrailles du pensionnat."
    jump rencontre_genoveva_nuit

    #ACTE 16
    #Scène 1 (interne/player/roger/unity)
label rencontre_genoveva_nuit:

    scene bg couloir
    with fade
    show roger neutral at center
    i "Nous traversons un labyrinthe de couloirs. Chaque tournant me paraît plus étroit que le précédent."
    i "Les néons de sécurité clignotent par instants, projetant nos ombres géantes et déformées sur les murs."
    i "Quand nous approchons de la section des filles, une alarme stridente éclate soudain. Mon cœur s’arrête."
    show roger annoyed
    r "\"Calme-toi. C’est normal. Chaque passage nocturne est enregistré.\""
    r "Personne ne circule sans signalement."
    i "Il ouvre un coffret métallique fixé au mur. Ses grosses mains actionnent un interrupteur. La sirène se tait aussitôt."
    i "Mais le silence qui suit est encore plus pesant, comme si les murs eux-mêmes retenaient leur souffle."
    show unity neutral at right
    i "Devant la porte du dortoir des filles, une surveillante nous attend, bras croisés. Ses yeux me transpercent comme des lames."
    u "\"Roger. Qu’est-ce que ça veut dire ?\""
    r "\"Nouvel arrivant. Il a oublié de rendre un document à Genoveva.\""
    i "Un long silence. Unity ne me lâche pas du regard. Ses doigts tapotent contre son bras comme pour compter mes excuses avant même que je parle."
    u "\"…\""
    u "\"Tu sais où est sa chambre ?\""
    p "\"Oui. Merci. J’en ai pour une minute.\""
    i "Elle soupire, mi-exaspérée, mi-fatiguée, et s’écarte à contrecœur."
    i "Je laisse Roger et Unity derrière moi, sous leurs regards croisés, et m’avance dans le couloir."
    hide unity
    hide roger
    i "L’ambiance est différente ici. Les portes sont entrouvertes, les lumières encore allumées. Des chuchotements s’échappent des chambres, des rires étouffés. Rien à voir avec le silence mortel du dortoir des garçons."
    
    #ACTE 17
    #Scène 1 (interne/player/genoveva)
    scene bg dortoir
    with fade
    i "J’arrive devant la porte de Genoveva. Elle est déjà là, dans l’embrasure, comme si elle m’attendait."
    show genoveva neutral4
    e "\"Tu… tu es vraiment venu. Même après le couvre-feu.\""
    i "Sa voix tremble à peine. Entre la surprise, la gêne… et peut-être une étincelle qu’elle tente de cacher."
    p "\"Je t’avais promis, non ?\""
    e "\"Comment t’as fait ?\""
    p "\"J’ai prétexté te ramener le document d’information.\""
    i "Elle rit doucement, un rire fragile qui se perd aussitôt dans le couloir."
    e "\"Et tu me l’as vraiment ramené ?\""
    i "Je fouille mes poches et tends la fameuse fiche."
    p "\"Bien sûr. Tiens.\""
    show genoveva neutral7
    e "\"Tu l’as pliée n’importe comment…\""
    i "Ses doigts glissent sur le papier froissé. Elle le déplie avec soin, le regarde, puis fronce les sourcils."
    e "\"Mais… tu ne l’as même pas remplie !\""
    p "\"Tu m’as jamais dit de la remplir. Tu m’as juste dit de la rendre.\""
    show genoveva neutral5
    e "\"…\""
    show genoveva neutral6
    i "Un petit sourire échappe à ses lèvres malgré elle. Elle secoue la tête, amusée et exaspérée à la fois."
    e "\"Va-t’en, maintenant.\""
    i "Son ton ferme brise l’instant fragile. Mais rien n’efface ce qui vient de se jouer : une promesse tenue, un interdit franchi."
    i "Dans ce pensionnat de règles et de murs, tenir parole ressemble presque à un acte de rébellion."
    i "Et derrière son air gêné, je crois l’avoir fait sourire."

    #ACTE 18
    #Scène 1 (interne/player/roger/unity)
    scene bg couloir
    with fade
    show roger neutral at center
    show unity neutral at right
    i "Je rejoins Roger et Unity, le souffle encore court."
    p "\"C’est bon. Merci.\""
    r "\"Bien. Échange terminé. Retour au dortoir.\""
    jump retour_dortoir


    #ACTE 19
    #Scène 1 (interne)
label retour_dortoir:

    scene bg dortoir nuit
    with fade
    i "De retour au dortoir, je me glisse sous les draps sans un bruit. Mes camarades dorment… ou font semblant."
    i "Le froissement des couvertures, les respirations lentes… une étrange famille improvisée."
    i "Je ferme enfin les yeux, le cœur battant encore de cette escapade nocturne."
    jump reve_colonies

label reve_colonies:
    play music "audio/3.mp3"
    scene black
    with fade
    window hide
    $ renpy.pause(1)
##############################################22.10##############
    i "Le sommeil m’arrache au dortoir. Les respirations régulières des autres disparaissent… remplacées par un silence qui n’a pas de fin."
    i "Une odeur revient. Fer chaud. Cendres mouillées. L’air est lourd, comme si chaque inspiration coûtait du sang."
    i "Je suis dans une rue étroite, les murs penchés comme des géants fatigués. Mais cette rue… je la connais. Elle ne mène nulle part."
    i "Les fenêtres sont des yeux, elles me fixent, elles me jugent. Derrière elles, des enfants se cognent contre les vitres sans bruit. Leurs bouches s’ouvrent… mais aucun cri ne sort."
    i "Je tends la main vers l’un d’eux. Ma paume se colle au verre. Le froid me mord, me traverse. L’enfant sourit. Et son sourire est le mien, plus jeune, plus affamé."
    i "Un coup de sifflet retentit. Sec. Tranchant. Le décor tremble. Les murs se plient, la rue s’allonge comme une cicatrice sans fin."
    i "Au loin, un drapeau flotte. Mais il est noir, traversé de fissures rouges qui coulent comme du sang encore tiède."
    i "Une voix appelle : « Cadet ! » Non… ce n’est pas ça. Le mot change, se déforme. « Esclave… détenu… vermine… » Chaque syllabe pèse comme un marteau sur ma nuque."
    i "Je veux répondre, mais ma langue est lourde. Elle colle à mon palais comme du plomb."
    i "Le ciel est blanc, blafard, sans soleil. Il me pèse sur les épaules, comme s’il voulait m’écraser contre le sol. Je tombe à genoux."
    i "Un enfant passe près de moi. Il tient une boîte en fer. À chaque pas, elle résonne comme une cloche funèbre. Il l’ouvre… et des mouches s’en échappent. Pas de nourriture, pas de trésor. Juste des ailes noires qui remplissent l’air."
    i "Je ferme les yeux, mais je continue de voir. Toujours cette rue. Toujours ces grilles. Derrière elles, des silhouettes rangées comme des pierres tombales. Elles marchent en cadence. Pas d’erreurs. Pas d’hésitations."
    i "Je reconnais leurs visages : des camarades d’avant. Vivants ? Morts ? Leurs yeux sont vides, mais je sais qu’ils m’ont connu."
    i "Une silhouette se détache. Grande. Autoritaire. Son visage est flou, effacé, comme recouvert d’un voile blanc. Mais sa main se lève, et aussitôt, tout s’arrête. Le silence se brise en mille morceaux."
    i "Cette main pointe vers moi. Un doigt accusateur, immense, qui me cloue au sol."
    i "« Toi. »"
    i "Le mot résonne comme un ordre et une condamnation. Ma poitrine se serre. Je veux fuir, mais mes jambes sont clouées."
    i "Les pavés se mettent à bouillir. Des lettres gravées apparaissent : Discipline. Obéissance. Sacrifice. Elles luisent comme des braises."
    i "Je crie. Ma voix se répercute, se déforme, devient mille voix qui me hurlent dessus. Elles répètent mes propres mots, mais transformés en prières, en slogans."
    i "Tout brûle. Le drapeau noir s’embrase. Les silhouettes fondent comme de la cire. Les enfants derrière les vitres éclatent en éclats de verre qui s’enfoncent dans ma peau."
    i "Je cours. Mais chaque pas me ramène au même endroit. La rue. Toujours la rue. Les grilles. Les murs. Les yeux."
    i "Un bruit de chaînes. Je baisse la tête. Mes poignets sont attachés. Mais ce ne sont pas mes mains : ce sont celles d’un enfant. Mon enfant. Moi, plus jeune. Je suis prisonnier de moi-même."
    i "Le ciel s’ouvre soudain. Pas une lumière. Un gouffre. Une gueule noire, béante, qui m’aspire. Je tombe. Je tombe sans fin."
    i "Et quand je crois toucher le sol…"

    scene bg dortoir nuit
    with fade
    play music "audio/4.mp3"

    i "… mes yeux s’ouvrent dans l’obscurité du dortoir."
    i "je met quelque seconde a comprendre que je suis dans ce foutu dortoire"
    i "Le souffle de mes camarades est toujours là. Mais mon cœur cogne encore, comme s’il voulait briser mes côtes."
    i "Rêve. Souvenir. Peu importe. Ça colle à ma peau comme une brûlure."
    i "j'ai pas mal transpirer au point de rendre les drap et le matelas humide"
    i "je peine a retrouver le someille dans ce lit humide"
    ############24.15####################
    scene bg lundi
    pause 
    scene bg lundi2
    pause 
    jump reveil

    #ACTE 20
    #Scène 1 (interne/player/roger/unity)
label reveil:

    scene bg dortoir matin
    with fade
    i "Un bruit métallique secoue mes rêves. La cloche. Son martèlement implacable résonne dans les murs du dortoir."
    i "Mes yeux s’ouvrent péniblement : le dortoir est déjà en mouvement."
    i "Marius saute hors de son lit en grognant, Anteo replie soigneusement ses affaires, et Sante, étonnamment vif, est déjà debout, les draps tirés au carré."
    show marius neutral at left
    show anteo neutral at right
    show sante neutral at center
    m "\"Allez, debout, recrue ! Ici, c’est pas l’hôtel, et le soleil n’attend personne.\""
    a "\"Si tu rates l’appel, ce sera corvée. Crois-moi, vaut mieux courir maintenant.\""
    s "\"Six heures. Comme tous les jours.\""
    i "Je me redresse, encore engourdi. Mes gestes sont hésitants, maladroits. Leurs mouvements sont déjà des automatismes."
    i "Un sifflet aigu perce le couloir. Pas le temps de traîner."
    jump petit_dej

    #ACTE 21
    #Scène 1 ((interne/player/marius/anteo/sante)
label petit_dej:

    scene bg cantine
    with fade
    i "La cantine résonne du vacarme des assiettes et des voix fatiguées. Une file interminable de cadets avance en silence relatif, chacun tenant son plateau métallique."
    i "Le repas est simple : pain sec, une pomme, un bol de gruau chaud. Rien de plus."
    show marius neutral at left
    show anteo neutral at right
    show sante neutral at center
    m "\"Ah, le fameux gruau. S’il avait du goût, on serait presque contents.\""
    a "\"Cesse de te plaindre. C’est nourrissant, et suffisant.\""
    s "\"Mange. La journée sera longue.\""
    i "Autour de nous, des dizaines de cadets avalent en silence. Certains chuchotent, d’autres fixent leur bol, perdus dans leurs pensées."
    i "Je lève discrètement les yeux, cherchant un visage parmi la foule : Genoveva."
    i "Des dizaines d’uniformes identiques, mais pas le sien. J’insiste, scrutant chaque table… Elle n’est pas là, ou bien je l’ai manquée."
    i "Une pointe de déception traverse mon estomac plus sûrement que le gruau."
    i "Un surveillant passe entre les tables, l’œil sévère. Pas question de traîner : la cloche de 7h15 résonne déjà au loin."
    jump ceremonie

    #ACTE 22
    #Scène 1 (interne/player/genoveva/aumonier)
label ceremonie:

    scene bg cour matin
    with fade
    i "À 7h30 précises, les cadets se rassemblent dans la cour. Des rangées impeccables s’étendent, rigides comme des colonnes de pierre."
    i "Mais moi… j’arrive quelques secondes trop tard. Mon pas résonne dans la cour déjà figée, chaque regard semble peser sur moi."
    i "Les surveillants m’adressent des œillades sévères, mais aucun ne dit mot. Je me glisse rapidement a l'extremiter d'un rang encore ouvert."
    show genoveva lundimatin at left 
    i "Le hasard — ou la providence — me place juste à côté d’elle. Genoveva."
    i "Elle tourne brièvement la tête, surprise de me voir. Ses yeux accrochent les miens une fraction de seconde, avant qu’elle ne fixe de nouveau droit devant elle, impeccable."
    i "Je retiens un sourire amer. Même noyé dans cette foule, sa simple présence fissure le décor parfait de l’uniformité."
    i "Les surveillants encadrent la cour, silhouettes immobiles comme des statues. Sur une estrade improvisée, le directeur ajuste son micro qui grésille."
    show galeazzo neutral at right
    g "\"Cadets, relevez la tête. Aujourd’hui comme hier, nous honorons ceux qui nous ont précédés.\""
    i "Un aumônier s’avance à ses côtés, drapé dans une soutane sombre. Sa voix grave s’élève, vibrante comme un sermon."
    show aumonier neutral at center
    o "\"Prions pour nos soldats. Pour ceux qui servent encore, et pour ceux qui sont tombés.\""
    i "Un silence total s’installe. Des centaines de têtes s’inclinent à l’unisson, comme une machine bien huilée."
    i "Genoveva baisse doucement la tête, ses cheveux glissant le long de sa joue. Une seconde, j’ai l’impression que son bras frôle le mien."
    e "\"Prends ma main.\""
    p "\"…Quoi ?\""
    i "Mon cœur rate un battement. J’ai rêvé ? Elle n’a pas pu dire ça. Non… et pourtant mes oreilles me brûlent."
    i "Peut-être qu’elle parlait à quelqu’un d’autre ? Je jette un discret coup d’œil vers elle."
    e "\"Prends ma main.\""
    i "Cette fois, j’en suis sûr. Mon cerveau s’arrête. Impossible… L’endroit, le moment, c’est le pire choix pour ce genre de phrase."
    i "La seule explication logique : j’ai mal entendu."
    p "\"T’as dit quoi ?\""
    i "Ses lèvres bougent encore. Son chuchotement se déforme dans le brouhaha."
    e "\"Prends les cinq saucisses qui dépassent de ma manche.\""
    p "\"…Hein ?!\""
    i "Je cligne des yeux. L’image est absurde. Mon esprit se brouille, partagé entre le sérieux de la prière et cette phrase ridicule."
    i "Et pourtant, elle lève légèrement sa main en direction de la mienne."
    i "Je reste figé, idiot. Alors, avec une assurance tranquille, c’est elle qui glisse sa paume contre la mienne."
    i "Sa main est tiède, ferme. Et soudain, je remarque : tout autour, les cadets se tiennent déjà par la main en silence."
    i "C’était le rituel, la coutume de cette prière à la con. Rien de plus."
    i "Je me sens stupide, mes joues chauffent. Comment ai-je pu croire un instant qu’il s’agissait de… d’autre chose ?"
    o "\"Qu’ils trouvent la force dans leur devoir, et la paix dans leur sacrifice.\""
    i "Je baisse les yeux comme les autres, mais pas par foi. Juste pour ne pas me faire remarquer."
    i "La scène me frappe par son absurdité : des enfants contraints de murmurer à un ciel vide, au nom d’un dieu d’État qu’on mélange à la guerre."
    i "Je ne crois pas en ces prières. Pas plus qu’aux drapeaux ou aux uniformes. La seule transcendance que je reconnais, c’est celle qu’on arrache soi-même à la vie."
    i "On mélange l’encens et la poudre à canon, la foi et les fusils. Une messe où les saints sont remplacés par des généraux, et où l’autel est une estrade en bois qui sent la rouille."
    i "À chaque 'amen', j’entends un ordre. À chaque chant, je n’entends qu’un rappel : obéissez, servez, mourez si nécessaire."
    i "Si c’est ça leur dieu, je préfère encore le néant. Le vide ne demande pas de comptes et n’envoie personne à l’abattoir."
    i "Et pourtant… la main de Genoveva, serrée contre la mienne, trouble mes certitudes. Une chaleur bien réelle, un lien qu’aucun serment militaire ne pourra m’arracher."
    i "À ma gauche, Genoveva garde une posture parfaite, son visage baigné d’un calme presque mystique. Je me demande si elle croit vraiment à ces conneries, ou si, comme moi, elle joue un rôle."
    i "devant, un cadet marmonne maladroitement les paroles, couvert par le chant solennel qui s’élève ensuite."
    i "Les voix montent, lourdes et puissantes, dans l’air froid du matin. Un chant de fer et de foi — mais moi, je n’entends que du bruit."
    o "\"Souvenez-vous : vous n’êtes pas seulement des élèves. Vous êtes la relève. L’honneur et la survie de notre pays reposent déjà sur vos épaules.\""
    i "Un dernier silence pèse comme une chape de plomb. Puis la cloche sonne, marquant la fin de la cérémonie et le début des cours."
    jump lundi8h
 
label lundi8h :
    scene bg classe

    i "La cloche métallique résonne encore dans les oreilles. Les cadets se figent, chacun vissé à son pupitre lustré comme une arme de cérémonie. "
    i "Les néons bourdonnent, diffusant une lumière maladive qui donne aux visages une pâleur spectrale."
    i "La porte s’ouvre. Un homme entre. Pas un surveillant, pas un soldat : le professeur d’éducation civique."
    show gentile neutral at center
    i "Costume sombre, gestes secs, regard méthodique. Pas de cris, pas de brutalité… mais quelque chose de plus inquiétant : un calme d’automate."
    i "Il pose un dossier sur son bureau, prend le temps de l’aligner avec les bords, puis lève enfin les yeux."
    n "\"Cadets. Bienvenue dans la matière qui fera de vous plus que des individus. Ici, vous apprendrez à être des citoyens. Et un citoyen… n’est pas une personne. C’est un rôle.\""
    i "Il laisse un silence. Ses mots s’incrustent comme une encre noire."
    n "\"L’histoire a prouvé que les sociétés échouent quand chacun se croit libre de suivre ses caprices. La liberté n’est pas l’absence de chaînes.\"" 
    n "\"La liberté, c’est comprendre de quelles chaînes nous avons besoin.\""
    i "Dans un sourire bref, presque imperceptible. Il écrit trois mots au tableau :"
    "Service – Harmonie – Pérennité."
    n "\"Vous avez sûrement entendu d’autres versions… discipline, obéissance, sacrifice. Mais retenez ceci : il ne s’agit pas d’obéir aveuglément. Il s’agit d’accepter que l’État pense mieux que vous.\""
    i "Il marche lentement entre les rangées, mains croisées derrière le dos. Chaque pas résonne comme un métronome."
    n "\"Dites-moi, cadet…\""
    i "Il s’arrête net devant un élève au hasard, le fixe sans ciller."
    n "\"Si votre voisin triche à un examen, que faites-vous ?\""
    ########################29.00##################################
    b "\"…Je le signale, monsieur.\""
    i "Un hochement sec."
    n "\"Exact. Car la faute d’un seul devient la faute de tous. La tolérance est un poison. Elle mine la confiance, détruit l’unité. En le dénonçant, vous le sauvez. Et vous sauvez la Nation.\""
    i "Il reprend sa marche. S’arrête cette fois près de moi"
    i "Ses yeux se plantent dans les tiens."
    n "\"Et vous, cadet [PlayerName] ? Que vaut une vérité personnelle… face à la vérité collective ?\""
    i "Le silence s’épaissit. Toute la salle retient son souffle. Ou juste moi..."
    
    menu:
        "\[DOCILE] \"La vérité collective est la seule qui compte.\"":
            i "Le professeur hoche la tête, satisfait."
            n "\"Bien. Vous avez compris.\""
            jump lundi8h2
        "\[DÉFIANT] \"Une vérité qu’on doit imposer n’a aucune force.\"":

        #"\[DÉFIANT] \"Une vérité qu’on doit imposer n’a aucune force.\"":
        # $ scoreaudacieux += 1
            i "Un frisson parcourt la salle. Personne ne respire. Le professeur me fixe, immobile."
            n "\"Intéressant.\""
            i "Son sourire n’a rien d’humain. On dirait une fissure dans un mur."
            n "\"Vous pensez donc que la vérité doit convaincre, plutôt que contraindre ?\""
            i "Je ne réponds pas. Son regard cherche une faille en moi, prêt à s'y engouffrer."
            n "\"Je prends note de votre… philosophie.\""
            i "Il dit cela comme on note un crime."
            n "\"J’espère pour vous que la Nation ne devra jamais imposer sa vérité… à quelqu’un qui pense comme vous.\""
            i "Sa voix ne s’élève pas d’un ton. Pourtant, la menace glisse dans l’air, douce et glaciale."
            jump lundi8h2


label lundi8h2 :
    i "Le professeur ouvre son dossier, sort une petite brochure grise : Le Contrat Citoyen. Chaque cadet en reçoit un exemplaire, posé sur son pupitre comme une arme neuve."
    n "\"Lisez l’Article Premier.\""
    i "Les pages bruissent. Les mots claquent : “Tout citoyen appartient d’abord à la Nation, avant d’appartenir à lui-même.”"
    i "nation et etat etais ici comme partout dans la pays melanger et avec le temps ces deux termes etait devenue des synonimes pour la plupart des gens "
    n "\"Certains trouvent cette phrase sévère. Mais pensez-y : si vous étiez seul, sans la Nation… qui vous nourrirait ?\""
    n "\"Qui vous protégerait ? Qui écrirait votre histoire ? Personne. Vous seriez une ombre. Alors, cessez d’avoir peur d’être un rouage : c’est la seule manière d’exister.\""
    i "Il marque une pause, l’air presque bienveillant."
    n "\" Demain, vous devrez réciter cet article par cœur. Non pas pour me plaire. Mais pour apprendre à respirer avec les autres.\""
    i "La cloche sonne de nouveau. Les cadets se lèvent en cadence, comme un seul corps."
    i "Mais ses derniers mots restent accrochés à ton esprit, comme une écharde : « Un citoyen n’est pas une personne. C’est un rôle. »"
    i "le professeur referme son dossier, puis lève une main sèche "
    n "\"Asseyez-vous. Vous croyez qu’un citoyen peut quitter son devoir quand bon lui semble ? La cloche est un outil… pas un maître.\""
    i "Un frisson traverse la salle. Tous se rassoient, raides."
    i "Il sort une feuille de son dossier. Dessus, un seul mot, écrit en rouge : “Trahison”. Il la brandit, puis la colle au tableau avec un aimant métallique."
    n "\"Parlons d’un cas pratique. Imaginons… qu’un citoyen refuse d’accomplir son service. Qu’il désobéisse aux ordres. Que doit-on faire ? \""
    i "Un murmure parcourt les rangs. Les regards se croisent, fuyants. Personne n’ose parler."
    i "Le professeur fixe un élève au premier rang."
    n "\"Toi.\""
    i "L’élève avale sa salive."
    b "\" …Il faut le punir, monsieur. \""
    n "\"Exact. Mais comment ? Punir n’est pas suffisant. Un citoyen défaillant met en péril la confiance du groupe.\""
    i "Il se tourne lentement vers la classe."
    n "\"Alors, je vous pose la question : qu’est-ce qu’une trahison mérite ?\""
    
    menu:
        "\[DOCILE] \" La trahison doit être effacée. Par l’exemple.\"":
            i "Le professeur sourit. « Bien. L’exemple purifie. En punissant un seul, on protège mille autres. »"
            n "\"Bien. Vous avez compris.\""
            jump lundi8h3
   

        "\[DEFIANT] \"Peut-être qu’il avait ses raisons. Comprendre d’abord, punir après.\"":
            i"Un rire sec échappe au professeur, sans joie."
            n "\"Comprendre, dites-vous ? Voilà une idée dangereuse. Comprendre, c’est déjà excuser. Et excuser, c’est ouvrir la porte à mille trahisons.\""
            jump lundi8h3
    

label lundi8h3:
    i"Le professeur reprend la craie et écrit au tableau :"
    "“La tolérance nourrit la rébellion.”"
    n "\"Notez cette phrase. Vous la recopierez dix fois ce soir, avant de dormir. Pas comme un devoir… mais comme un vaccin.\""
    i"Il range son dossier avec lenteur, puis conclut :"
    n "\"Retenez bien ce que nous avons fait aujourd’hui. L’éducation civique n’est pas une théorie. C’est un entraînement. Une discipline de l’esprit. Vous apprendrez à penser juste. Et penser juste… c’est penser comme la Nation.\""
    i"Il marque un dernier silence, puis ajoute d’une voix plus basse, presque douce :"
    n "\"Le citoyen qui hésite est déjà un ennemi.\""
    i"La cloche sonne de nouveau. Cette fois, il fait un signe sec :"
    n "\"Maintenant, vous pouvez partir.\""
    i "Les pupitres raclent en cadence, les cadets quittent la salle dans un silence compact. Le mot “Trahison”, en rouge sur le tableau, reste derrière vous comme une cicatrice qui refuse de disparaître."

    scene bg couloir
    i " La cloche résonne encore dans les murs quand la masse des cadets se déverse dans le couloir. Les pas frappent le sol comme une seule marée. Personne ne parle trop fort. Le silence du cours continue de peser, comme si chaque mot risquait d’être répété aux mauvaises oreilles."
    i "À ma droite, Marius ricane doucement, les mains dans les poches."
    show marius neutral at left
    m "\"Eh ben… pour un premier cours, c’était du sport. Si ça continue, on va finir par rêver de punir nos propres ombres.\""
    i "Il imite à voix basse le ton du professeur "
    m "\"Le citoyen qui hésite est déjà un ennemi…\"" #changer color pour celle du prof
    i "marius me fait un  clin d’œil ironique. "
    m "\"Je parie qu’il s’entraîne devant le miroir, tous les matins.\""
    i "À l’opposé, Anteo secoue la tête. Son ton est calme, mais ferme."
    show anteo neutral at right
    a "\"Tu plaisantes, mais tu ferais mieux de réfléchir. Si un surveillant t’avait entendu, tu serais déjà noté dans un rapport. Ici, chaque mot compte.\""
    i "Marius hausse les épaules, faussement nonchalant."
    m "\"Ouais, ouais. On verra bien.\""
    i "Derrière, Sante marche en silence, son carnet serré contre lui. Ses yeux fixent le sol, mais sa voix grave se fait entendre "
    show sante neutral at center
    s "\"Il a raison sur un point. Le silence est dangereux. Pas pour nous… mais pour celui qui le garde.\""
    s "\"C’est comme offrir sa gorge à la lame.\""
    i "Son ton sec glace l’air un instant."
    i "Puis Genoveva, qui marchait légèrement en avant, se retourne vers moi. Ses yeux bleus accrochent les miens."
    hide sante 
    show genoveva neutral at center
    e "\"Et toi, [PlayerName] ? Qu’est-ce que tu en penses ?\""
    i "Son regard est sérieux, mais une étincelle d’ironie y danse, comme si elle cherchait à percer ta façade."
    menu:
        "\[TIMIDE] \"\"Je pense qu’il a raison. Sans discipline, tout s’effondre.\"":
            $ scoretimide += 1
            p "\"Je pense qu’il a raison. Sans discipline, tout s’effondre. \""
            i "Genoveva acquiesce, mais ses yeux se voilent légèrement."
            m "\" Oh, parfait… encore un soldat modèle.\""
            jump  lundi8h4

        "\[AUDACIEUX] \"\"C’était un lavage de cerveau. Ils veulent juste qu’on s’accuse entre nous. »":
            p "« C’était un lavage de cerveau. Ils veulent juste qu’on s’accuse entre nous. »"
            $ scoreaudacieux += 1
            i "Genoveva esquisse un sourire imperceptible, vite effacé."
            i "Marius lui éclate de rire" 
            m "« Enfin quelqu’un qui a des yeux ! »"
            i "Anteo, fronce les sourcils"
            a "\"Tais-toi. Tu ne sais pas qui écoute.\""
            i "Sante lève la tête, ses yeux perçants se plantent dans les tiens."
            s "\"Méfie-toi. Ceux qui parlent trop ne parlent jamais longtemps.\""
            jump lundi8h4

label lundi8h4:
    i "Le groupe avance dans le couloir. Derrière les rires étouffés de Marius, les avertissements d’Anteo, les silences de Sante et les regards de Genoveva,"
    i " une vérité se dessine : chacun a sa propre manière de survivre ici."

    label end_demo:
    scene black with fade
    centered "DEMO TERMINÉE\n\nMerci d’avoir joué à cette première version du jeu.\nL’aventure ne fait que commencer.\n\nPour suivre le développement et découvrir la date de sortie :\nwww.copyleftfactory.com\n\nÀ très vite pour la suite."
    return





